/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipCl1_Public.h 85289 2019-08-21 08:27:15Z kai $:

Description:
   Task EthernetIP Cl1
   public declaration of task

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2010-11-01    created
**************************************************************************************/

/*
 * EipCl1_Public.h
 * Eip Cl1 - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specific definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __EIP_CL1_PUBLIC_H
#define __EIP_CL1_PUBLIC_H


/*************************************************************************************/
/* queue name */
#define EIP_CL1_QUEUE_NAME        "QUE_EIP_CL1"


/*************************************************************************************/
/* The following defined structures represent the timer functions of the task */

#define EIP_CL1_MAX_TIMEOUT       0x3FFFFFFFL

#define  EIP_CL1_TIMER_DUMMY      0x00
#define  EIP_CL1_TIMER_CONTINUOUS 0x01
#define  EIP_CL1_TIMER_ONE_SHOT   0x02


typedef struct EIP_CL1_TIMERBLK_Ttag
{
  struct EIP_CL1_TIMERBLK_Ttag *ptPrev;
  struct EIP_CL1_TIMERBLK_Ttag *ptNext;

  TLR_BOOLEAN             fSync;         /* stores "serviced" sync state        */

  TLR_UINT32              ulMode;        /* timer re-trigger mode               */
  TLR_UINT32              ulNotify;      /* timer notify mode                   */

  TLR_UINT32              ulDelayTime;   /* current delay time in milli seconds */
  TLR_UINT32              ulRetrigger;   /* timer re-trigger time               */

  TLR_VOID (CALLBACK FAR* fnExp) (TLR_VOID *ptRsc, TLR_VOID FAR* pvInpt);
  TLR_VOID FAR*           pvInpt;
} EIP_CL1_TIMERBLK_T;

typedef struct EIP_CL1_TIMER_Ttag
{
  EIP_CL1_TIMERBLK_T *  ptActiveTimersList;   /* List of active timers */
  EIP_CL1_TIMERBLK_T *  ptDelayTimersPool;    /* Free delay timers list */
  EIP_CL1_TIMERBLK_T *  ptNewMinTimer;        /* New minimum value timer */
  TLR_UINT32            ulTimerCtr;           /* Active timer's down counter.
                                                 If this counter reaches 0,
                                                 the timer is expired. */
  TLR_UINT32            ulTimerRef;           /* In conjunction with ulTimerCtr, this
                                                 value is used to keep track of the elapsed time
                                                 (time since the minimum timer expired the last time).
                                                 You can calculate the elapsed time with:
                                                 elapsedTime = ulTimerRef - ulTimerCtr */
  TLR_PACKET_HEADER_T   tWakeupPckt;          /* As soon as the timer expires, this packet
                                                 is sent. */
  TLR_BOOLEAN           fTimerSyncState;      /* Service state sync boolean */
} EIP_CL1_TIMER_T;


/* Prototyps for Cl1 Timer */
EIP_CL1_TIMERBLK_T * Eip_Cl1CreateTimer(  TLR_UINT32        ulMode,
                                          TLR_UINT32        ulDelay,
                                          TLR_UINT32        ulRetrigger,
                                          TLR_VOID (CALLBACK FAR* fnExp) (TLR_VOID FAR* pvRsc, TLR_VOID FAR* pvInpt),
                                          TLR_VOID FAR*     pvInpt );

TLR_RESULT Eip_Cl1DeleteTimer( EIP_CL1_TIMER_T *ptCl1Timer, EIP_CL1_TIMERBLK_T *ptTimer );

TLR_RESULT Eip_Cl1RetriggerTimer( EIP_CL1_TIMER_T *ptCl1Timer, EIP_CL1_TIMERBLK_T *ptTimer );

TLR_RESULT Eip_Cl1StartTimer( EIP_CL1_TIMER_T *ptCl1Timer, EIP_CL1_TIMERBLK_T *ptTimer );

TLR_RESULT Eip_Cl1StopTimer( EIP_CL1_TIMER_T *ptCl1Timer, EIP_CL1_TIMERBLK_T *ptTimer );

TLR_VOID   Eip_SendCl1Msg(TLR_VOID* pvRsc, EIP_CL1_MSG_T *ptCl1SendMsg);
TLR_VOID   SendCl1MessageIfInhibitTimerNotRunning( TLR_VOID* pvRsc, EIP_CL1_MSG_T* ptCl1SendMsg );
TLR_VOID   Eip_TripleBuffCb( TLR_HANDLE ulTriBuf, EIP_TRANSPORT_T* ptTransport );


/*************************************************************************************/
/* packets */
/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__EIP_DLR_PACKET)
#endif


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__EIP_DLR_PACKET)
#endif

#endif /* #ifndef __EIP_CL1_PUBLIC_H */
